/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.pet_cemetery.core.data.client;

import com.teamabnormals.pet_cemetery.core.registry.PCEntityTypes;
import com.teamabnormals.pet_cemetery.core.registry.PCItems;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.text.WordUtils;

public class PCLanguageProvider
extends LanguageProvider {
    public PCLanguageProvider(DataGenerator gen) {
        super(gen, "pet_cemetery", "en_us");
    }

    public void addTranslations() {
        this.add((Item)PCItems.PET_COLLAR.get());
        this.add((Item)PCItems.ZOMBIE_WOLF_SPAWN_EGG.get(), (Item)PCItems.ZOMBIE_CAT_SPAWN_EGG.get(), (Item)PCItems.ZOMBIE_PARROT_SPAWN_EGG.get(), (Item)PCItems.SKELETON_WOLF_SPAWN_EGG.get(), (Item)PCItems.SKELETON_CAT_SPAWN_EGG.get(), (Item)PCItems.SKELETON_PARROT_SPAWN_EGG.get());
        this.add((EntityType)PCEntityTypes.ZOMBIE_WOLF.get(), (EntityType)PCEntityTypes.ZOMBIE_CAT.get(), (EntityType)PCEntityTypes.ZOMBIE_PARROT.get(), (EntityType)PCEntityTypes.SKELETON_WOLF.get(), (EntityType)PCEntityTypes.SKELETON_CAT.get(), (EntityType)PCEntityTypes.SKELETON_PARROT.get());
        this.add("tooltip.pet_cemetery.baby", "Baby");
        this.addAdvancement("nether.respawn_pet", "Frankenweenie", "Respawn a pet using a Pet Collar at a Respawn Anchor");
        this.addAdvancement("nether.cured_zombie_pet", "Zombie Veterinarian", "Weaken and then cure a Zombie pet");
        this.addAdvancement("nether.respawn_zombie_pet", "Grim Reaper", "Respawn a Zombie pet as a Skeleton");
    }

    private void add(Item ... entries) {
        for (Item entry : entries) {
            if (ForgeRegistries.ITEMS.getKey((Object)entry) == null) continue;
            this.add(entry, this.format(ForgeRegistries.ITEMS.getKey((Object)entry)));
        }
    }

    private void add(EntityType<?> ... entries) {
        for (EntityType<?> entry : entries) {
            if (ForgeRegistries.ENTITY_TYPES.getKey(entry) == null) continue;
            this.add(entry, this.format(ForgeRegistries.ENTITY_TYPES.getKey(entry)));
        }
    }

    private void addAdvancement(String key, String title, String description) {
        String intro = "advancements.pet_cemetery." + key + ".";
        this.add(intro + "title", title);
        this.add(intro + "description", description);
    }

    private String format(ResourceLocation registryName) {
        return WordUtils.capitalizeFully((String)registryName.m_135815_().replace("_", " "));
    }
}

